<?php
include('check_login.php');
?>
<!DOCTYPE html>
<html lang="en">
<head>
 <title>Sales Turnover Analysis Chart</title>
    <meta charset="utf-8">
	<meta name="viewport" content="width=device-width, initial-scale=1">
	<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
	<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
	<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
	<link rel="stylesheet" type="text/css" href="responsive.css">
</head>
<body>
    <!-- Navigation Bar -->
    <nav class="navbar navbar-expand-lg navbar-light bg-light">
        <div class="container-fluid">
            <!-- Toggler button for collapsing the menu on smaller screens -->
            <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navbarNav" aria-controls="navbarNav" aria-expanded="false" aria-label="Toggle navigation">
                <span class="navbar-toggler-icon"></span>
            </button>
            
            <div class="collapse navbar-collapse" id="navbarNav">
                <ul class="navbar-nav me-auto mb-2 mb-lg-0">
                    <li class="nav-item">
                        <a class="nav-link active" aria-current="page" href="/index.php">Home</a>
                    </li> 
                    <li class="nav-item">
                        <a class="nav-link" aria-current="page" href="/upload.php">Upload</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" href="/chart.php">Chart</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" href="/logout.php">Logout</a>
                    </li>
                </ul>
            </div>
        </div>
    </nav>

    <div class="container mt-4">
        

        <h1>Welcome to Sales Turnover Analysis Chart</h1>
		<form action="" id="uploadForm" method="post" enctype="multipart/form-data">
            
            <div class="mb-3">
                <label for="file" class="form-label">Upload File:</label>
                <input type="file" id="file" name="file" class="form-control" required>
            </div>
            <button type="submit" id="sbmt_btn" class="btn btn-primary">Upload</button>
        </form>
        <div id="progress"></div>
		<br>
		<div class="progress" style="display:none;">
		  <div class="progress-bar progress-bar-striped progress-bar-animated" role="progressbar" aria-valuenow="75" aria-valuemin="0" aria-valuemax="100" style="width: 1%"></div>
		</div>
    </div>
	<script>
        $(document).ready(function () {
            $('#uploadForm').on('submit', function (e) {
                e.preventDefault();
                var formData = new FormData(this);
				$('#sbmt_btn').prop('disabled', true);
				$('#progress').html('File is uploading.....');
                $.ajax({
                    url: 'upload_file.php',
                    type: 'POST',
                    data: formData,
                    contentType: false,
                    processData: false,
                    success: function (response) {
						$('#progress').html('File is uploaded...');
						$('.progress').show();
                        processBatch(response);
						
                    }
                });
            });

            function processBatch(filePath, start = 0, batchSize = 200) {
				
                $.ajax({
                    url: 'process.php',
                    type: 'POST',
					dataType: "json",
                    data: { file: filePath, start: start, batchSize: batchSize },
                    success: function (response) {
                        console.log(response.continue);
						if (response.continue == true) {
							var nw = (100 * response.processed)/response.total_record;
							$('.progress-bar').css('width',nw+'%');
                            $('#progress').html('Processed ' + response.processed + ' records so far...out of total record '+response.total_record);
                            processBatch(filePath, start + batchSize, batchSize);
                        } else {
                            $('#progress').html('All records processed.');
							$('.progress-bar').css('width','100%')
							$('#sbmt_btn').prop('disabled', false);
                        }
                    }
                });
            }
        });
    </script>
   
</html>
