<?php
	include('db.php');
	$end_date = date('Y-m-t');
	$start_date = date('Y-01-01');
	
		
	$start_date = '2022-01-01';
	$end_date = '2022-12-31';
	$clinicSelection = "all";
	$clinicSelection = "Klinik Oasis Pelangi Damansara";
	$typesel = '';
		$query = "SELECT invoice_amount, visit_datetime,type FROM patient_details WHERE visit_datetime BETWEEN ? AND ?";
		$params = [$start_date, $end_date];
		$types = "ss"; // Types for bind_param

		// Add condition for clinic_name if not 'all'
		if ($clinicSelection !== 'all') {
			$query .= " AND clinic_name = ?";
			$params[] = $clinicSelection;
			$types .= "s"; // Adding string type for clinic_name
		}
        $query .= " ORDER BY visit_datetime ASC";
           
	

		// Prepare the statement
		$stmt = $conn->prepare($query);
		if ($stmt === false) {
			die("Error preparing the query: " . $conn->error);
		}

		// Bind parameters dynamically
		$stmt->bind_param($types, ...$params);

		
		$stmt->execute();

		
		$result = $stmt->get_result();
		
		$stmt->close();

		// Close the connection
		$conn->close();
		
		
		
		
		
		$monthly_data = [];
		$month_labels = [];
		while ($row = $result->fetch_assoc()) {
			$invoice_amount = floatval($row['invoice_amount']);
			$visit_datetime = new DateTime($row['visit_datetime']);
			$current_month = $visit_datetime->format('Y-m');
        
		    if($row['type'] == 'Panel')
		    {
		        // Initialize if the month doesn't exist in array
    			if (!isset($monthly_data['Panel'][$current_month])) {
    				$monthly_data['Panel'][$current_month] = [
    					'month_start' => date('Y-m-01', strtotime($current_month)),
    					'month_end' => date('Y-m-t', strtotime($current_month)),
    					'total_amount' => 0,
    					'num_records' => 0
    				];
    				$month_labels['Panel'][] = date('F Y', strtotime($current_month));
    			}
    
    			// Accumulate totals for the current month
    			$monthly_data['Panel'][$current_month]['total_amount'] += $invoice_amount;
    			$monthly_data['Panel'][$current_month]['num_records']++;
		    }
			 if($row['type'] == 'Cash')
		    {
		        // Initialize if the month doesn't exist in array
    			if (!isset($monthly_data['Cash'][$current_month])) {
    				$monthly_data['Cash'][$current_month] = [
    					'month_start' => date('Y-m-01', strtotime($current_month)),
    					'month_end' => date('Y-m-t', strtotime($current_month)),
    					'total_amount' => 0,
    					'num_records' => 0
    				];
    				$month_labels['Cash'][] = date('F Y', strtotime($current_month));
    			}
    
    			// Accumulate totals for the current month
    			$monthly_data['Cash'][$current_month]['total_amount'] += $invoice_amount;
    			$monthly_data['Cash'][$current_month]['num_records']++;
		    }
		    
		     if($row['type'] == 'Total')
		    {
		        // Initialize if the month doesn't exist in array
    			if (!isset($monthly_data['Total'][$current_month])) {
    				$monthly_data['Total'][$current_month] = [
    					'month_start' => date('Y-m-01', strtotime($current_month)),
    					'month_end' => date('Y-m-t', strtotime($current_month)),
    					'total_amount' => 0,
    					'num_records' => 0
    				];
    				$month_labels['Total'][] = date('F Y', strtotime($current_month));
    			}
    
    			// Accumulate totals for the current month
    			$monthly_data['Total'][$current_month]['total_amount'] += $invoice_amount;
    			$monthly_data['Total'][$current_month]['num_records']++;
		    }
		}

		$start = new DateTime($start_date);
		$end = new DateTime($end_date);
		$end->modify('+1 day'); // Include the end date in the loop

		// Create a DateInterval of 1 day
		$interval = new DateInterval('P1D');

		// Create a DatePeriod instance to iterate through each day
		$period = new DatePeriod($start, $interval, $end);

		// Loop through each date in the period
		foreach ($period as $date) {
			$current_month = $date->format('Y-m');
			if (!isset($monthly_data['Panel'][$current_month])) {
				$monthly_data['Panel'][$current_month] = [
					'month_start' => date('Y-m-01', strtotime($current_month)),
					'month_end' => date('Y-m-t', strtotime($current_month)),
					'total_amount' => 0,
					'num_records' => 0
				];
				$month_labels['Panel'][] = date('F Y', strtotime($current_month));
			}
			
				if (!isset($monthly_data['Cash'][$current_month])) {
				$monthly_data['Cash'][$current_month] = [
					'month_start' => date('Y-m-01', strtotime($current_month)),
					'month_end' => date('Y-m-t', strtotime($current_month)),
					'total_amount' => 0,
					'num_records' => 0
				];
				$month_labels['Cash'][] = date('F Y', strtotime($current_month));
			}
			
				if (!isset($monthly_data['Total'][$current_month])) {
				$monthly_data['Total'][$current_month] = [
					'month_start' => date('Y-m-01', strtotime($current_month)),
					'month_end' => date('Y-m-t', strtotime($current_month)),
					'total_amount' => 0,
					'num_records' => 0
				];
				$month_labels['Total'][] = date('F Y', strtotime($current_month));
			}
		}
		

		
		$monthly_data_array = array_values($monthly_data);
		$total_amounts = array_column($monthly_data['Panel'], 'total_amount');
       
        ksort($monthly_data["Cash"]);
        ksort($monthly_data["Panel"]);
        ksort($monthly_data["Total"]);
        ksort($month_labels['Panel']);
        
        usort($month_labels['Panel'], function($a, $b) {
    $dateA = DateTime::createFromFormat('F Y', $a);
    $dateB = DateTime::createFromFormat('F Y', $b);
    return $dateA <=> $dateB;
});
        echo "<pre>";
        var_dump($month_labels['Panel']);
        echo "</pre>";
        echo "<pre>";
        var_dump($monthly_data);
        echo "</pre>";

		$total_amounts = array_column($monthly_data_array, 'total_amount');
		$num_records = array_column($monthly_data_array, 'num_records');
		if( $data_display == 'amountcount')
		{
					$data_to_send = [
				'total_amounts' => $total_amounts,
				'num_records' => $num_records,
				'labels' => $month_labels
			];
		}
		elseif ( $data_display == 'amount' )
		{
				$data_to_send = [
				'total_amounts' => $total_amounts,
				'labels' => $month_labels
			];
		}
		else
		{
				$data_to_send = [
				'num_records' => $num_records,
				'labels' => $month_labels
			];
		}
		
	
		
		