<?php
function get_month_data( $result, $start_date, $end_date, $data_display )
{
	    $monthly_data = [];
		$month_labels = [];
		while ($row = $result->fetch_assoc()) {
			$invoice_amount = floatval($row['invoice_amount']);
			$visit_datetime = new DateTime($row['visit_datetime']);
			$current_month = $visit_datetime->format('Y-m');

		 if($row['type'] == 'Panel')
		    {
		        // Initialize if the month doesn't exist in array
    			if (!isset($monthly_data['Panel'][$current_month])) {
    				$monthly_data['Panel'][$current_month] = [
    					'month_start' => date('Y-m-01', strtotime($current_month)),
    					'month_end' => date('Y-m-t', strtotime($current_month)),
    					'total_amount' => 0,
    					'num_records' => 0
    				];
    				$month_labels['Panel'][] = date('F Y', strtotime($current_month));
    			}
    
    			// Accumulate totals for the current month
    			$monthly_data['Panel'][$current_month]['total_amount'] += $invoice_amount;
    			$monthly_data['Panel'][$current_month]['num_records']++;
		    }
			 if($row['type'] == 'Cash')
		    {
		        // Initialize if the month doesn't exist in array
    			if (!isset($monthly_data['Cash'][$current_month])) {
    				$monthly_data['Cash'][$current_month] = [
    					'month_start' => date('Y-m-01', strtotime($current_month)),
    					'month_end' => date('Y-m-t', strtotime($current_month)),
    					'total_amount' => 0,
    					'num_records' => 0
    				];
    				$month_labels['Cash'][] = date('F Y', strtotime($current_month));
    			}
    
    			// Accumulate totals for the current month
    			$monthly_data['Cash'][$current_month]['total_amount'] += $invoice_amount;
    			$monthly_data['Cash'][$current_month]['num_records']++;
		    }
		    
		     if($row['type'] == 'Total')
		    {
		        // Initialize if the month doesn't exist in array
    			if (!isset($monthly_data['Total'][$current_month])) {
    				$monthly_data['Total'][$current_month] = [
    					'month_start' => date('Y-m-01', strtotime($current_month)),
    					'month_end' => date('Y-m-t', strtotime($current_month)),
    					'total_amount' => 0,
    					'num_records' => 0
    				];
    				$month_labels['Total'][] = date('F Y', strtotime($current_month));
    			}
    
    			// Accumulate totals for the current month
    			$monthly_data['Total'][$current_month]['total_amount'] += $invoice_amount;
    			$monthly_data['Total'][$current_month]['num_records']++;
		    }
		}

		$start = new DateTime($start_date);
		$end = new DateTime($end_date);
		$end->modify('+1 day'); // Include the end date in the loop

		// Create a DateInterval of 1 day
		$interval = new DateInterval('P1D');

		// Create a DatePeriod instance to iterate through each day
		$period = new DatePeriod($start, $interval, $end);

		// Loop through each date in the period
		foreach ($period as $date) {
			$current_month = $date->format('Y-m');
				if (!isset($monthly_data['Panel'][$current_month])) {
				$monthly_data['Panel'][$current_month] = [
					'month_start' => date('Y-m-01', strtotime($current_month)),
					'month_end' => date('Y-m-t', strtotime($current_month)),
					'total_amount' => 0,
					'num_records' => 0
				];
				$month_labels['Panel'][] = date('F Y', strtotime($current_month));
			}
			
				if (!isset($monthly_data['Cash'][$current_month])) {
				$monthly_data['Cash'][$current_month] = [
					'month_start' => date('Y-m-01', strtotime($current_month)),
					'month_end' => date('Y-m-t', strtotime($current_month)),
					'total_amount' => 0,
					'num_records' => 0
				];
				$month_labels['Cash'][] = date('F Y', strtotime($current_month));
			}
			
				if (!isset($monthly_data['Total'][$current_month])) {
				$monthly_data['Total'][$current_month] = [
					'month_start' => date('Y-m-01', strtotime($current_month)),
					'month_end' => date('Y-m-t', strtotime($current_month)),
					'total_amount' => 0,
					'num_records' => 0
				];
				$month_labels['Total'][] = date('F Y', strtotime($current_month));
			}
		}
		

		
		$monthly_data_array = array_values($monthly_data);
        ksort($monthly_data["Cash"]);
        ksort($monthly_data["Panel"]);
        ksort($monthly_data["Total"]);
            
             
             usort($month_labels['Panel'], function($a, $b) {
    $dateA = DateTime::createFromFormat('F Y', $a);
    $dateB = DateTime::createFromFormat('F Y', $b);
    return $dateA <=> $dateB;
});
		$total_amounts_panel = array_column($monthly_data['Panel'], 'total_amount');
		$num_records_panel = array_column($monthly_data['Panel'], 'num_records');
		
		$total_amounts_cash = array_column($monthly_data['Cash'], 'total_amount');
		$num_records_cash = array_column($monthly_data['Cash'], 'num_records');
		
		$total_amounts_total = array_column($monthly_data['Total'], 'total_amount');
		$num_records_total = array_column($monthly_data['Total'], 'num_records');
		
		if( $data_display == 'amountcount')
		{
					$data_to_send = [
				'total_amounts_panel' => $total_amounts_panel,
				'num_records_panel' => $num_records_panel,
				'labels_panel' => $month_labels['Panel'],
				
				'total_amounts_cash' => $total_amounts_cash,
				'num_records_cash' => $num_records_cash,
				'labels_cash' => $month_labels['Cash'],
				
				'total_amounts_total' => $total_amounts_total,
				'num_records_total' => $num_records_total,
				'labels_total' => $month_labels['Total'],
			];
		}
		elseif ( $data_display == 'amount' )
		{
			$data_to_send = [
				'total_amounts_panel' => $total_amounts_panel,
				'labels_panel' => $month_labels['Panel'],
				
				'total_amounts_cash' => $total_amounts_cash,
				'labels_cash' => $month_labels['Cash'],
				
				'total_amounts_total' => $total_amounts_total,
				'labels_total' => $month_labels['Total'],
			];
		}
		else
		{
			$data_to_send = [
				
				'num_records_panel' => $num_records_panel,
				'labels_panel' => $month_labels['Panel'],
				
			
				'num_records_cash' => $num_records_cash,
				'labels_cash' => $month_labels['Cash'],
				
				
				'num_records_total' => $num_records_total,
				'labels_total' => $month_labels['Total'],
			];
		}
		
		header('Content-Type: application/json');
		echo json_encode($data_to_send);
		exit;
}

?>