<?php
	include('db.php');
include('get_month_data.php');
if(isset($_POST['chartType']))
{
			$start_date = $_POST['start_date'];
			$end_date = $_POST['end_date'];
			$data_display = $_POST['dataDisplay'];
			$clinicSelection = $_POST['clinicSelection'];
			$typesel = (isset($_POST['typesel']))?$_POST['typesel']:"";
			$result = get_data($conn,$start_date,$end_date,$clinicSelection,$typesel);
		
		
			switch ($_POST['chartType']) {
			case 'year':
				get_year_data($result,$start_date,$end_date,$data_display);
				break;
			case 'month':
				get_month_data($result,$start_date,$end_date,$data_display);
				break;
			case 'weekly':
				get_week_data($result,$start_date,$end_date,$data_display);
				break;
			case 'daily':
				get_day_data($result,$start_date,$end_date,$data_display);
				break;
			
		}
		
}

function get_data( $conn, $start_date, $end_date, $clinicSelection, $typesel )
{
		

		
		$query = "SELECT invoice_amount, visit_datetime,type FROM patient_details WHERE visit_datetime BETWEEN ? AND ?";
		$params = [$start_date, $end_date];
		$types = "ss"; // Types for bind_param

		// Add condition for clinic_name if not 'all'
		if ($clinicSelection !== 'all') {
			$query .= " AND clinic_name = ?";
			$params[] = $clinicSelection;
			$types .= "s"; // Adding string type for clinic_name
		}

	    $query .= " ORDER BY visit_datetime";

		// Prepare the statement
		$stmt = $conn->prepare($query);
		if ($stmt === false) {
			die("Error preparing the query: " . $conn->error);
		}

		// Bind parameters dynamically
		$stmt->bind_param($types, ...$params);

		
		$stmt->execute();

		
		$result = $stmt->get_result();
		
		$stmt->close();

		// Close the connection
		$conn->close();
		return $result;
}







function get_year_data($result,$start_date,$end_date,$data_display)
{
	$yearly_data = [];
	$year_labels = [];
while ($row = $result->fetch_assoc()) {
    $invoice_amount = floatval($row['invoice_amount']);
    $visit_datetime = new DateTime($row['visit_datetime']);

    // Get the year key (e.g., '2024' for the year 2024)
    $current_year = $visit_datetime->format('Y');

    // Initialize if the year doesn't exist in array
    if (!isset($yearly_data[$current_year])) {
        $yearly_data[$current_year] = [
            'year' => $current_year,
            'total_amount' => 0,
            'num_records' => 0
        ];
        $year_labels[] = $current_year;
    }

    // Accumulate totals for the current year
    $yearly_data[$current_year]['total_amount'] += $invoice_amount;
    $yearly_data[$current_year]['num_records']++;
}

$start = new DateTime($start_date);
		$end = new DateTime($end_date);
		$end->modify('+1 day'); // Include the end date in the loop

		// Create a DateInterval of 1 day
		$interval = new DateInterval('P1D');

		// Create a DatePeriod instance to iterate through each day
		$period = new DatePeriod($start, $interval, $end);

		// Loop through each date in the period
		foreach ($period as $date) {
			$current_year = $date->format('Y');
			
			$yearly_data[$current_year] = [
            'year' => $current_year,
            'total_amount' => 0,
            'num_records' => 0
        ];
        $year_labels[] = $current_year;
		}

// Convert weekly data to simple array format
$yearly_data_array = array_values($yearly_data);

		$total_amounts = array_column($yearly_data_array, 'total_amount');
		$num_records = array_column($yearly_data_array, 'num_records');
		if( $data_display == 'amountcount')
		{
					$data_to_send = [
			'total_amounts' => $total_amounts,
			'num_records' => $num_records,
			'labels' => $year_labels
		];
		}
		elseif ( $data_display == 'amount' )
		{
				$data_to_send = [
			'total_amounts' => $total_amounts,
			'labels' => $year_labels
		];
		}
		else
		{
				$data_to_send = [
			
			'num_records' => $num_records,
			'labels' => $year_labels
		];
		}	
		
		header('Content-Type: application/json');
		echo json_encode($data_to_send);
		exit;
}





/* function get_week_data($result,$start_date,$end_date,$data_display)
{
	// Initialize arrays to hold weekly data
$weekly_data = [];
$week_labels = [];

// Initialize variables to calculate totals
$current_week_start = new DateTime($start_date);
if ($current_week_start->format('N') != 1) {
    
   $current_week_start->modify('last Monday');
}


$current_week_end = clone $current_week_start;
$current_week_end->modify('+6 days');

// Loop through each result row

while ($row = $result->fetch_assoc()) {
    $invoice_amount = floatval($row['invoice_amount']);
    $visit_datetime = new DateTime($row['visit_datetime']);
	
	
	
    // Check if $visit_datetime is within the current week
    if ($visit_datetime->format('Y-m-d') >= $current_week_start->format('Y-m-d') && $visit_datetime->format('Y-m-d') <= $current_week_end->format('Y-m-d')) {
		
        // Accumulate totals for the current week
        $weekly_data[$current_week_start->format('Y-m-d')] = [
            'week_start' => $current_week_start->format('Y-m-d'),
            'week_end' => $current_week_end->format('Y-m-d'),
            'total_amount' => isset($weekly_data[$current_week_start->format('Y-m-d')]['total_amount']) ? 
                $weekly_data[$current_week_start->format('Y-m-d')]['total_amount'] + $invoice_amount : 
                $invoice_amount,
            'num_records' => isset($weekly_data[$current_week_start->format('Y-m-d')]['num_records']) ? 
                $weekly_data[$current_week_start->format('Y-m-d')]['num_records'] + 1 : 
                1
        ];
    } 
	
	else {
        // Move to the next week
		$i++;
        $current_week_start->modify('+7 days');
        $current_week_end->modify('+7 days');

        // Reset total and record count for new week
        $weekly_data[$current_week_start->format('Y-m-d')] = [
            'week_start' => $current_week_start->format('Y-m-d'),
            'week_end' => $current_week_end->format('Y-m-d'),
            'total_amount' => $invoice_amount,
            'num_records' => 1
        ];
    }
}



// Convert weekly data to simple array format
$weekly_data_array = array_values($weekly_data);

$total_amounts = array_column($weekly_data_array, 'total_amount');
		$num_records = array_column($weekly_data_array, 'num_records');


		if( $data_display == 'amountcount')
		{
				$data_to_send = [
			'total_amounts' => $total_amounts,
			'num_records' => $num_records,
			'labels' => array_map(function($week) {
            return $week['week_start'] . ' to ' . $week['week_end'];
        }, $weekly_data_array)
		];
		}
		elseif ( $data_display == 'amount' )
		{
				$data_to_send = [
			'total_amounts' => $total_amounts,			
			'labels' => array_map(function($week) {
            return $week['week_start'] . ' to ' . $week['week_end'];
        }, $weekly_data_array)
		];
		}
		else
		{
				$data_to_send = [
				'num_records' => $num_records,
				'labels' => array_map(function($week) {
				return $week['week_start'] . ' to ' . $week['week_end'];
			}, $weekly_data_array)
			];
		}	
		
		header('Content-Type: application/json');
		echo json_encode($data_to_send);
		exit;

} */

function get_week_data($result, $start_date, $end_date, $data_display) {
    // Initialize arrays to hold weekly data
    $weekly_data = [];
    $week_labels = [];

    // Create an array of all dates between start_date and end_date
    $period = new DatePeriod(
        new DateTime($start_date),
        new DateInterval('P1D'),
        (new DateTime($end_date))->modify('+1 day')
    );

    $all_dates = [];
    foreach ($period as $date) {
        $all_dates[$date->format('Y-m-d')] = [
            'invoice_amount' => 0,
            'visit_datetime' => $date->format('Y-m-d')
        ];
    }

    // Populate the $all_dates array with actual data from $result
    while ($row = $result->fetch_assoc()) {
        $visit_date = (new DateTime($row['visit_datetime']))->format('Y-m-d');
        if (!isset($all_dates[$visit_date])) {
            $all_dates[$visit_date] = [
                'invoice_amount' => floatval($row['invoice_amount']),
                'visit_datetime' => $visit_date
            ];
        } else {
            $all_dates[$visit_date]['invoice_amount'] += floatval($row['invoice_amount']);
        }
    }

    // Initialize variables to calculate totals
    $current_week_start = new DateTime($start_date);
    if ($current_week_start->format('N') != 1) {
        $current_week_start->modify('last Monday');
    }

    $current_week_end = clone $current_week_start;
    $current_week_end->modify('+6 days');

    // Process the combined data from $all_dates
    foreach ($all_dates as $date => $data) {
        $visit_datetime = new DateTime($data['visit_datetime']);
        $invoice_amount = $data['invoice_amount'];

        // Check if $visit_datetime is within the current week
        if ($visit_datetime >= $current_week_start && $visit_datetime <= $current_week_end) {
            // Accumulate totals for the current week
            $weekly_data[$current_week_start->format('Y-m-d')] = [
                'week_start' => $current_week_start->format('Y-m-d'),
                'week_end' => $current_week_end->format('Y-m-d'),
                'total_amount' => isset($weekly_data[$current_week_start->format('Y-m-d')]['total_amount']) ?
                    $weekly_data[$current_week_start->format('Y-m-d')]['total_amount'] + $invoice_amount :
                    $invoice_amount,
                'num_records' => isset($weekly_data[$current_week_start->format('Y-m-d')]['num_records']) ?
                    $weekly_data[$current_week_start->format('Y-m-d')]['num_records'] + 1 :
                    1
            ];
        } else {
            // Move to the next week
            $current_week_start->modify('+7 days');
            $current_week_end->modify('+7 days');

            // Reset total and record count for new week
            $weekly_data[$current_week_start->format('Y-m-d')] = [
                'week_start' => $current_week_start->format('Y-m-d'),
                'week_end' => $current_week_end->format('Y-m-d'),
                'total_amount' => $invoice_amount,
                'num_records' => 1
            ];
        }
    }

    // Convert weekly data to simple array format
    $weekly_data_array = array_values($weekly_data);

    $total_amounts = array_column($weekly_data_array, 'total_amount');
    $num_records = array_column($weekly_data_array, 'num_records');

    if ($data_display == 'amountcount') {
        $data_to_send = [
            'total_amounts' => $total_amounts,
            'num_records' => $num_records,
            'labels' => array_map(function($week) {
                return $week['week_start'] . ' to ' . $week['week_end'];
            }, $weekly_data_array)
        ];
    } elseif ($data_display == 'amount') {
        $data_to_send = [
            'total_amounts' => $total_amounts,
            'labels' => array_map(function($week) {
                return $week['week_start'] . ' to ' . $week['week_end'];
            }, $weekly_data_array)
        ];
    } else {
        $data_to_send = [
            'num_records' => $num_records,
            'labels' => array_map(function($week) {
                return $week['week_start'] . ' to ' . $week['week_end'];
            }, $weekly_data_array)
        ];
    }

    header('Content-Type: application/json');
    echo json_encode($data_to_send);
    exit;
}


function get_day_data($result,$start_date,$end_date,$data_display)
{
	$daily_data = [];
$day_labels = [];
while ($row = $result->fetch_assoc()) {
    $invoice_amount = floatval($row['invoice_amount']);
    $visit_datetime = new DateTime($row['visit_datetime']);

    // Get the day key (e.g., '2024-01-01' for January 1, 2024)
    $current_day = $visit_datetime->format('Y-m-d');

    // Initialize if the day doesn't exist in array
    if (!isset($daily_data[$current_day])) {
        $daily_data[$current_day] = [
            'day' => $current_day,
            'total_amount' => 0,
            'num_records' => 0
        ];
        $day_labels[] = $visit_datetime->format('F j, Y'); // Format the label as desired
    }
		
    // Accumulate totals for the current day
    $daily_data[$current_day]['total_amount'] += $invoice_amount;
    $daily_data[$current_day]['num_records']++;
}

$start = new DateTime($start_date);
		$end = new DateTime($end_date);
		$end->modify('+1 day'); // Include the end date in the loop

		// Create a DateInterval of 1 day
		$interval = new DateInterval('P1D');

		// Create a DatePeriod instance to iterate through each day
		$period = new DatePeriod($start, $interval, $end);
        /* echo '<pre>';
        var_dump( $period );
        echo '</pre>'; */
		// Loop through each date in the period
		foreach ($period as $date) {
			$current_day = $date->format('Y-m-d');

			// Initialize if the day doesn't exist in array
			if (!isset($daily_data[$current_day])) {
				$daily_data[$current_day] = [
					'day' => $current_day,
					'total_amount' => 0,
					'num_records' => 0
				];
				$day_labels[] = $date->format('F j, Y'); // Format the label as desired
			}
		}


// Convert weekly data to simple array format
$daily_data_array = array_values($daily_data);

		$total_amounts = array_column($daily_data_array, 'total_amount');
		$num_records = array_column($daily_data_array, 'num_records');
		if( $data_display == 'amountcount')
		{
				$data_to_send = [
			'total_amounts' => $total_amounts,
			'num_records' => $num_records,
			'labels' => $day_labels
		];
		}
		elseif ( $data_display == 'amount' )
		{
				$data_to_send = [
			'total_amounts' => $total_amounts,
			'labels' => $day_labels
		];
		}
		else
		{
				$data_to_send = [
			'num_records' => $num_records,
			'labels' => $day_labels
		];
		}	
		
		header('Content-Type: application/json');
		echo json_encode($data_to_send);
		exit;
}
?>