<?php
include('check_login.php');
?>
<!DOCTYPE html>
<html lang="en">
<head>
 <title>Sales Turnover Analysis Chart</title>
    <meta charset="utf-8">
	<meta name="viewport" content="width=device-width, initial-scale=1">
	<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
	<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
	<script src="https://ajax.googleapis.com/ajax/libs/jquery/3.7.1/jquery.min.js"></script>
	<link rel="stylesheet" type="text/css" href="responsive.css">
</head>
<body>
    <!-- Navigation Bar -->
    <nav class="navbar navbar-expand-lg navbar-light bg-light">
        <div class="container-fluid">
            <!-- Toggler button for collapsing the menu on smaller screens -->
            <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navbarNav" aria-controls="navbarNav" aria-expanded="false" aria-label="Toggle navigation">
                <span class="navbar-toggler-icon"></span>
            </button>
            
            <div class="collapse navbar-collapse" id="navbarNav">
                <ul class="navbar-nav me-auto mb-2 mb-lg-0">
                    <li class="nav-item">
                        <a class="nav-link active" aria-current="page" href="/index.php">Home</a>
                    </li> 
                    <li class="nav-item">
                        <a class="nav-link" aria-current="page" href="/upload.php">Upload</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" href="/chart.php">Chart</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" href="/logout.php">Logout</a>
                    </li>
                </ul>
            </div>
        </div>
    </nav>

    <div class="container mt-4">
        
       <form id="chartForm">
      <div class="row mb-3">
        <div class="col">
          <label class="form-label">Chart Type Selection</label>
          <div class="form-check">
            <input class="form-check-input" type="radio" name="chartType" class="chart_type_sel" id="chartTypeYear" value="year">
            <label class="form-check-label" for="chartTypeYear">Year</label>
          </div>
          <div class="form-check">
            <input class="form-check-input" type="radio" name="chartType" class="chart_type_sel" id="chartTypeMonth" value="month" checked="checked">
            <label class="form-check-label" for="chartTypeMonth" >Month</label>
          </div>
          <div class="form-check">
            <input class="form-check-input" type="radio" name="chartType" class="chart_type_sel" id="chartTypeWeekly" value="weekly">
            <label class="form-check-label" for="chartTypeWeekly"class="chart_type_sel" >Weekly</label>
          </div>
          <div class="form-check">
            <input class="form-check-input" type="radio" name="chartType" class="chart_type_sel" id="chartTypeDaily" value="daily">
            <label class="form-check-label" for="chartTypeDaily">Daily</label>
          </div>
        </div>
		<?php
		
		$today = date('Y-m-t');

		
		$threeMonthsBack = date('Y-01-01');
		?>
        <div class="col">
          <label for="periodFrom" class="form-label">Period Selection Range - From</label>
          <input type="date" class="form-control" name="start_date" id="periodFrom" value="<?php echo $threeMonthsBack; ?>">
        </div>
        <div class="col">
          <label for="periodTo" class="form-label">To</label>
          <input type="date" class="form-control" name="end_date" id="periodTo" value="<?php echo $today; ?>">
        </div>
      </div>
      <div class="row mb-3">
        <div class="col">
          <label class="form-label">Type Selection</label>
          <div class="form-check">
            <input class="form-check-input" type="checkbox" name="typesel[]" checked value="total" id="typeTotal">
            <label class="form-check-label" for="typeTotal">Total</label>
          </div>
          <div class="form-check">
            <input class="form-check-input" type="checkbox" value="panel" checked name="typesel[]" id="typePanel">
            <label class="form-check-label" for="typePanel">Panel</label>
          </div>
          <div class="form-check">
            <input class="form-check-input" type="checkbox" value="cash" checked name="typesel[]" id="typeCash">
            <label class="form-check-label" for="typeCash">Cash</label>
          </div>
        </div>
        <div class="col">
          <label class="form-label">Data Display Selection</label>
		  <div class="form-check">
            <input class="form-check-input" type="radio" name="dataDisplay" id="dataDisplayAmountCount" value="amountcount" checked="checked">
            <label class="form-check-label" for="dataDisplayAmountCount">Amount + Count</label>
          </div>
          <div class="form-check">
            <input class="form-check-input" type="radio" name="dataDisplay" id="dataDisplayAmount" value="amount">
            <label class="form-check-label" for="dataDisplayAmount">Amount</label>
          </div>
          <div class="form-check">
            <input class="form-check-input" type="radio" name="dataDisplay" id="dataDisplayCount" value="count">
            <label class="form-check-label" for="dataDisplayCount">Count</label>
          </div>
          
        </div>
        <div class="col">
		<?php
			include('db.php');
    		$sql = "SELECT DISTINCT clinic_name FROM patient_details";
    		// Execute the query
    		$result = $conn->query($sql);
            // Close the connection
            $conn->close();
		?>
			<label for="clinicSelection" class="form-label">Selection of Clinic</label>
			<select class="form-select" id="clinicSelection" name="clinicSelection">
				<option value="all">All</option>
				
				<?php
				// Check if there are results and fetch them
				if ($result->num_rows > 0) {
					while ($row = $result->fetch_assoc()) {
						if(empty($row['clinic_name']))
						{
							continue;
						}
						echo "<option value='".$row['clinic_name']."'>".$row['clinic_name']."</option>";
					}
					
				} 
				?>
			</select>
		</div>
      </div>
      <button type="submit" class="btn btn-primary" >Generate Chart</button>
    </form>
		<canvas id="comboChart" width="400" height="200"></canvas>
        <div>
  
</div>

<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>

<script>
$(document).ready(function(){
	 
	var counter = 0;
  $('#chartForm').on('submit', function(event) {
	  event.preventDefault();
	  
	  
    $.ajax({
                    url: 'get_data.php',
                    method: 'POST',
                    data: $(this).serialize(),
                    dataType: 'json',
                    success: function(data) {
						console.log(data);
						 
                        renderChart(data);
						
                    },
                    error: function(xhr, status, error) {
                        console.error('Error loading data:', error);
                    }
                });
  });
  $('#chartForm').submit();
  function renderChart(data)
  {
	  let chartStatus = Chart.getChart("comboChart"); // <canvas> id
		if (chartStatus != undefined) {
		  chartStatus.destroy();
		}
	  const aLabels = data.labels_panel;
	const panelCheckbox = document.getElementById('typePanel');
  const cashCheckbox = document.getElementById('typeCash');
  const totalCheckbox = document.getElementById('typeTotal');
 
	// Extract data for chart
	const totalAmounts_panel = data.total_amounts_panel;
	const numRecords_panel = data.num_records_panel;
	
    const totalAmounts_cash = data.total_amounts_cash;
	const numRecords_cash = data.num_records_cash;
	
	const totalAmounts_total = data.total_amounts_total;
	const numRecords_total = data.num_records_total;
	const datasets = [];
	
	if (totalCheckbox.checked) {
      datasets.push({
        type: 'bar',
        label: 'Total Amount',
        data: totalAmounts_total,
        backgroundColor: 'rgba(255, 173, 0, 0.2)',
        borderColor: 'rgba(255, 173, 0, 1)',
        borderWidth: 1
      });
      datasets.push({
        type: 'line',
        label: 'Total Count',
        data: numRecords_total,
        fill: false,
        borderColor: 'rgba(255, 173, 0, 1)',
        tension: 0.1
      });
    }
    
	if (panelCheckbox.checked) {
      datasets.push({
        type: 'bar',
        label: 'Panel Amount',
        data: totalAmounts_panel,
        backgroundColor: 'rgba(0, 0, 255, 0.2)',
        borderColor: 'rgba(0, 0, 255, 1)',
        borderWidth: 1
      });
      datasets.push({
        type: 'line',
        label: 'Panel Count',
        data: numRecords_panel,
        fill: false,
        borderColor: 'rgba(0, 0, 255, 1)',
        tension: 0.1
      });
    }

    if (cashCheckbox.checked) {
      datasets.push({
        type: 'bar',
        label: 'Cash Amount',
        data: totalAmounts_cash,
        backgroundColor: 'rgba(0, 255, 0, 0.2)',
        borderColor: 'rgba(0, 255, 0, 1)',
        borderWidth: 1
      });
      datasets.push({
        type: 'line',
        label: 'Cash Count',
        data: numRecords_cash,
        fill: false,
        borderColor: 'rgba(0, 255, 0, 1)',
        tension: 0.1
      });
    }
			// Chart.js setup
			const ctx = document.getElementById('comboChart').getContext('2d');
			const comboChart = new Chart(ctx, {
				type: 'bar',
				data: {
					labels: aLabels,
					datasets: datasets
				    
				},
				options: {
					scales: {
						y: {
							beginAtZero: true
						}
					}
				}
			});
  }
});
</script>
    </div>

   
</html>
